clc
clear all
close all
all_marks = {'o','+','*','.','x','s','d','^','v','>','<','p','h'};

set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
%% Parametri fisici e gemetrici
Ts=293;              %Temperatura ambiente durante la prova [K]
k=1.4;               % Rapporto calori specifici
Rg=287.053;          %Costante dell'aria [J/kg/K]
mu=1.81e-5;          %Viscosita` dinamica dell'aria a 20°C [Pa s]
Pa=101325;           %Pressione ambiente durante la prova
rho=Pa/(Rg*Ts);      %Desità dell'aria alla temperatura della prova
cG=60000/rho;       %Coefficiente di conversione da kg/s >>> l/min ANR  

Test=3;
P=1;

Caricamento1=['load P' num2str(P) '_getto_libero_' num2str(Test) '.txt'];
eval(Caricamento1)
% Caricamento2=['load Getto_libero_NW_D65_d' num2str(Test) '.txt'];
% eval(Caricamento2)


% Portata_salita=['Q2=Getto_libero_NW_D65_d' num2str(Test)  '(:,1);'];
% Pressione_salita=['P2=Getto_libero_NW_D65_d' num2str(Test)  '(:,2)*1e5+Pa;'];
Portata_discesa=['Q1=P' num2str(P) '_getto_libero_' num2str(Test) '(:,1);'];
Pressione_discesa=['P1=P' num2str(P) '_getto_libero_' num2str(Test) '(:,2)*1e5+Pa;'];


%eval(Portata_salita)
 eval(Portata_discesa)
%eval(Pressione_salita)
 eval(Pressione_discesa)


%Parametri da identificare
K=3.8*1e-16;  %permeabilità (m^2)
L=6e-3;     %spessore strato poroso (m)
d=37e-3;
A=pi*d^2/4;
% Vettore delle pressioni di monte
Ps=linspace(Pa,8e5,1000);
%Formula di Darcy
Gd=(K*A)./(2*mu*Rg*Ts*L).*(Ps.^2-Pa^2);
rho_a=Pa/(Rg*Ts);
Qd=60000*Gd./rho_a;


 % Q1=Q1-0.1;

%%Plot di tutto il range di pressione 
figure
plot(P1,Q1*10,'ko','linewidth',4,'MarkerSize',8),hold on   % plotto Q1*10 perchè in fase di acqusizione sul banco ho utilizzato un canale di acqusizione con una scala 10 volte più piccola 
plot(Ps,Qd,'r','linewidth',4,'MarkerSize',8),hold on
xlabel('Pressione di alimentazione $p_s$ (Pa)'),ylabel('Portata  $ Q \quad(l/min \quad ANR \quad 20^{\circ} C)$'), 
grid on, zoom on,
legend('Numerico','Sperimentale')
xlim([0.95e5 8.25e5])

Permeabilita=['K_' num2str(Test) '=K;'];
eval(Permeabilita)

Salvataggio=['save P' num2str(P) '_getto_libero_' num2str(Test) ' K_' num2str(Test)];
        
         eval(Salvataggio)